#!/bin/bash
# This *is* a bash script, not sh...

prefix=/usr
exec_prefix=/usr
datarootdir=${prefix}/share

# perform a NTP update sync, before starting Enigma2, as it is broke in OE.
#if [ -x /usr/sbin/ntpdate ]; then
#	/usr/sbin/ntpdate -s -u pool.ntp.org && sleep 2
#fi

# hook to execute user startup script before enigma2 start
if [ -x /etc/enigma2/startup.sh ]; then
	/etc/enigma2/startup.sh
fi

do_reader_kill=0
if [ -e /proc/stb/info/boxtype ]; then
# Set relevant boxtypes to 1 - missing ones are treated as 0.
	declare -A boxtest=(
		viper4k 1   beyonwizv2 1    sf8008 1    sf8008m 1
		sfx6008 1   sx988 1         sx88v2 1    gbmv200 1
	)
	stbcheck=`cat /proc/stb/info/boxtype`
	if [ ${boxtest[$stbcheck]:-0} -eq 1 ]; then
		count=`ps -ef |grep libreader |grep -v "grep" |wc -l`
		if [ 0 == $count ];then
			libreader 720P_50
			do_reader_kill=1
		fi
	fi
	unset boxtest
fi

if [ -x /usr/bin/showiframe ]; then
	SKIN=`sed -En 's|config\.skin\.primary_skin=(.+)/skin\.xml|\1|p' /etc/enigma2/settings`
	if [ -z "$SKIN" ]; then
		SKIN=`strings -n 10 /usr/lib/enigma2/python/skin.pyc | egrep -o -m 1 ".+/skin.xml" | sed 's|/skin.xml.*||'`
	fi
	if [ -n "${SKIN}" ]; then
		SEARCHDIRS="/etc/enigma2/${SKIN} /etc/enigma2/skin_common /etc/enigma2 /usr/share/enigma2/${SKIN} /usr/share/enigma2/skin_default /usr/share/enigma2 /usr/share"
	else
		SEARCHDIRS="/etc/enigma2/skin_common /etc/enigma2 /usr/share/enigma2/skin_default /usr/share/enigma2 /usr/share"
	fi
	for DIR in ${SEARCHDIRS}; do
		if [ -d "${DIR}" ] && [ -f "${DIR}/backdrop.mvi" ]; then
			/usr/bin/showiframe "${DIR}/backdrop.mvi" &
			break
		fi
	done
fi

# hook to execute scripts always before enigma2 start
if [ -x /usr/bin/enigma2_pre_start.sh ]; then
	/usr/bin/enigma2_pre_start.sh
fi

if [ -d /home/root ]; then
	export HOME=/home/root
	cd
fi

# Pre-load libopen, which will set the Close-on-Exec flag for all opened
# file units so that they don't leak into sub-processes.
#
#check for sundtek tuner helper lib
if [ -e /opt/lib/libmediaclient.so ]; then
	LIBS="/opt/lib/libmediaclient.so /usr/lib/libopen.so.0.0.0"
else
	LIBS="/usr/lib/libopen.so.0.0.0"
fi

sync

(sleep 2; echo "enigma2 is the main pvr application... adjust oom score!"; PID=$(pidof enigma2); \
	[ -e /proc/$PID/oom_score_adj ] && echo "-999" > /proc/$PID/oom_score_adj || echo "-17" > /proc/$PID/oom_adj;) &

export LC_CTYPE="en_US.UTF-8"

# set time format used to prefix each line in the debug logs
#
if grep -q 'config\.crash\.logtimeformat' /etc/enigma2/settings; then
	export ENIGMA_DEBUG_TIME=`grep "config\.crash\.logtimeformat" /etc/enigma2/settings | sed -E "s/^.*=(.*)$/\1/" -`
fi

# Enable generation of core dumps
debug_dir=$(sed -n 's/config.crash.debug_path=//p' /etc/enigma2/settings)
	[ -n "${debug_dir}" -a -d "${debug_dir}" ] || debug_dir=/home/root/logs/
# It would be best to have this at system startup because this way we may not
# catch core dumps that happen early to enigma2.
# The kernel.core_pattern could be set via /etc/sysctl.conf.
# The size limit could be set via /etc/security/limits.conf.
if [ "$(grep -i config.crash.coredump=true /etc/enigma2/settings)" != "" ]; then
	COREDUMPSIZE=$((10 * 512 * 4 - 1 * 512 * 4)) # size is in blocks (512 byte) so this sets 10 MB - 1 MB for log files
	COREDUMPFILE=${debug_dir}%t-enigma2-core.dump
	if [ "$(grep -i config.crash.sizeloglimit= /etc/enigma2/settings | sed 's/config.crash.sizeloglimit=//g')" != "" ]; then
		COREDUMPSIZE=$(grep -i config.crash.sizeloglimit= /etc/enigma2/settings | sed 's/config.crash.sizeloglimit=//g')
		COREDUMPSIZE=$((${COREDUMPSIZE} * 512 * 4 - 1 * 512 * 4))
	fi
	echo ${COREDUMPFILE} > /proc/sys/kernel/core_pattern
	ulimit -c ${COREDUMPSIZE}
fi
# If we are running with a log then we need to set up a sub-process to
# do this so that it can open a new log if the current one's size
# becomes too large.
# So, we define various functions for use
#
if grep -q 'config\.crash\.enabledebug=True' /etc/enigma2/settings; then
	DEBUG_LVL='4'

# Generate a random message for the logger to know that enigma2 has
# ended
#
    unem="Enigma2 is LEAVING: $RANDOM"

# ========== Start of log functions ==========
# fixup_log() - remove any partial-line at the end a logfile as we
# switch and add a note there instead.
#
    fixup_log() {
        old="$1"
        new="$2"

# Remove the fsize limit, so we can add the continuation tag.
# We're in a subprocess and exit when done, so this won't affect
# restricting the active log file
#
        ulimit -S -f unlimited

# An in-line python script...
        python - "$old" "$new" <<EOP
import sys, os

ofile = sys.argv[1]
nfile = sys.argv[2]
size = os.stat(ofile).st_size
pos = size - (size % 1024)

# We partition the file into 1024-byte blocks (plus the probably
# incomplete one at the end), read them in reverse order and
# look for the last newline character in each block.
# As soon as we've found one we've found the last newline in the file.
# Anything beyond that is an incomplete line which took us to the
# file-size limit, so we truncate there and add the new log location.
# The complete text of any such incomplete ending line will be written
# at the start of the next log, after the note of the preceding log.
#
with open(ofile, "r+b") as f:
    while pos >= 0:
        f.seek(pos)
        buf = f.read(1024)
        where = buf.rfind(b"\n")
        if where < 0:
            pos -= 1024
            continue
# OK, we've found the last newline
# seek there and truncate
#
        f.seek(pos + where + 1)
        f.truncate()
# Now add the note as to where future logging has gone
#
        f.write(b"Continued in %s\n" % bytes(nfile, "UTF8"))
        break
EOP
    }

# new_log() - open a new log and, if this is a restart, note the
# next/prev logs pathnames at the end/start of the relevant logs
#
    new_log() {
        if [ -n "$logname" ]; then
            prev=$logname
        else
            prev=
        fi
        logname="${debug_dir}/Enigma2_debug_`date +%Y-%m-%d_%H-%M-%S`.log"
        exec > $logname 2>&1    # Open the new one
# If we have opened a new one then we wish to record what the previous
# one was and also to remove any partial-line at the end of the old log
# and note the new logname there instead.
# We do this in the background so that we can get on with logging.
#
        if [ -n "$prev" ]; then
            fixup_log "$prev" "$logname"&
            echo "Continued from $prev"
            logswitched=0
        else
            logswitched=1
        fi
    }

# Set a new file-size limit
# We MUST ensure that this is ONLY set for the dblogger - NOT enigma2!!!
# ulimit uses 1024-byte units, so we must multiply the configured limit
# (in MB) by 1024
#
    new_limit() {
        lim=$(($1 * 1024))
        ulimit -S -f $lim
    }

# dblogger - the main function. This receives the log text on
# stdout
#
    dblogger() {

# We want the logger to ignore TERM, so that if a reboot command is run
# from the command line this doesn't get booted out before enigma2
# closes down.
# We'll exit when enigma2 does anyway (the "read line" will fail).
#
        trap "" SIGTERM

        logname=
        lim=
        logswitched=0
        debug_dir="/home/root/logs"

# We look for config.crash.debugloglimit in settings
# (default == 4, see Screens/LogManager.py) and use it:
#
        debugloglimit=`awk -F= '
 BEGIN{res=4};
 $1 == "config.crash.debugloglimit" {res=$2; exit};
 END{print res}' /etc/enigma2/settings`

        new_limit $debugloglimit

# We look for config.crash.debug_path in settings
# (default == /home/root/logs/, see Screens/LogManager.py) and use it:
#
        raw=`awk -F= '
 BEGIN{res="/home/root/logs/"};
 $1 == "config.crash.debug_path" {res=$2; exit};
 END{print res}' /etc/enigma2/settings`
        debug_dir=${raw%/}      # Strip trailing / if there.
        trap new_log SIGXFSZ    # Re-opener
        new_log                 # First opener

# The values will be reported at start-up, but we've already read and
# handled them above, so set flags to ignore them the first time.
#
        first_limit=1   # Not yet seen
        first_lpath=1   # Not yet seen

        echo "========== Enigma2 log starts =========="
        while read -r line; do      # -r == no slash-escaping of input
            case "$line" in
# Are we being told that enigma2 has exited?
# If so, we exit too
#
            $unem)
                echo "enigma2 has exited"
                break
                ;;
# Have we been asked to change the limit or log path?
# If so, activate the change.
# We'll log the CHANGE line as well....
#
            CHANGE\ config.crash.debugloglimit=*)
                if [ $first_limit -eq 1 ]; then
                    first_limit=0
                else
                    debugloglimit=`echo $line |
                         sed -e's/^.*config.crash.debugloglimit=//'`
                    new_limit $debugloglimit
                fi
                ;;
            CHANGE\ config.crash.debug_path=*)
                if [ $first_lpath -eq 1 ]; then
                    first_lpath=0
                else
                    raw=`echo $line |
                         sed -e's/^.*config.crash.debug_path=//'`
                    debug_dir=${raw%/}      # Strip trailing / if there.
                    new_log
# new_log() will set logswitched, but we don't want to rewrite this line
# for this case, so unset it
#
                    logswitched=0
                fi
                ;;
            esac
            echo "$line"
            if [ $logswitched -eq 1 ]; then # New log opened
                echo "$line"                # Write full line into new log
                logswitched=0
            fi
        done

# enigma2 has left.
# As we leave, lift the limit (so we don't potentially create a
# new log just to record the closing) and record this.
#
        ulimit -S -f unlimited
        echo "========== Enigma2 log ends =========="
    }
# ========== End of log functions ==========

# Run into a logging function in such a way that when
# enigma2 exits the logger exits too.
# We need to get the exit code from enigma2, not the logger
#
        ( LD_PRELOAD=$LIBS /usr/bin/enigma2 # run enigma2
            xstat=$?                        # its exit code
            echo                            # in case of mid-line crisis
            echo $unem                      # marker to end logger
            exit $xstat                     # exit code for this "block"
        ) 2>&1 | dblogger
	ret=${PIPESTATUS[0]}    # enigma2 exit code, not dblogger's
else
	# if debug logs are disabled
	if grep -q 'config\.misc\.firstrun=False' /etc/enigma2/settings; then
		# Write unwanted output to /dev/null. Do not write output to the serial port or the receiver will run slow.
		LD_PRELOAD=$LIBS /usr/bin/enigma2 &> /dev/null
	else
		# on first run only, write the output to the serial port
		LD_PRELOAD=$LIBS /usr/bin/enigma2
	fi
	ret=$?
fi

enigma2pid=$!

# Enable generation of core dumps with ELF header included.
# This seem to be required by gdb.
# Would be default if kernel is configured with CONFIG_CORE_DUMP_DEFAULT_ELF_HEADERS.
# Default coredump filter can only be set via kernel command line.
# In all other cases this is only available per process.
if [ "$(grep -i config.crash.coredump=true /etc/enigma2/settings)" != "" ]; then
	COREDUMPFILTER=0x33
	echo ${COREDUMPFILTER} > /proc/${enigma2pid}/coredump_filter
fi

wait ${enigma2pid}

# enigma2 exit codes:
#
# 1 - halt
# 2 - reboot
# 3 - restart enigma
#
# >128 signal


if [ "$ret" -ne "1" ]; then
	if [ $do_reader_kill -ne 0 ]; then
		killall -9 libreader; sleep 5
	fi
fi

# hook to execute user standby script before enigma2 exits
if [ -x /etc/enigma2/standby.sh ]; then
	/etc/enigma2/standby.sh
fi

case $ret in
	1)
		/sbin/halt
		;;
	2)
		/sbin/reboot
		;;
	3)
		rm -f /tmp/.listen.camd.socket.ignore
		;;
	12)
		if [ -e /dev/block/by-name/bootoptions ]; then
			mkdir -p /tmp/bootoptions
			mount /dev/block/by-name/bootoptions /tmp/bootoptions
			cp -f /tmp/bootoptions/STARTUP_ANDROID /tmp/bootoptions/STARTUP_ONCE
		else
			echo "rescue" > /proc/stb/fp/boot_mode
		fi
		/sbin/reboot
		;;
	16)
		if [ -e /dev/block/by-name/flag ]; then
			echo -n "0" > /dev/block/by-name/flag
		elif [ -e /dev/block/by-name/bootoptions ]; then
			mkdir -p /tmp/bootoptions
			mount /dev/block/by-name/bootoptions /tmp/bootoptions
			cp -f /tmp/bootoptions/STARTUP_RECOVERY /tmp/bootoptions/STARTUP_ONCE
		elif [ -e /boot/STARTUP_RECOVERY ]; then
			cp -f /boot/STARTUP_RECOVERY /boot/STARTUP_ONCE
		else
			echo "rescue" > /proc/stb/fp/boot_mode
		fi
		[[ -e /etc/enigma2/.deep ]] && rm /etc/enigma2/.deep
		/sbin/reboot
		;;
	42)
		python /usr/lib/enigma2/python/upgrade.pyc
		;;
	43)
		init 1
		;;
	*)
		rm -f /tmp/.listen.camd.socket.ignore
		;;
esac
